package com.example.chatapp.activities

import android.annotation.SuppressLint
import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.os.Handler
import android.os.Looper
import android.util.Log
import android.widget.TextView
import com.example.chatapp.ChatApplication
import com.example.chatapp.R
import com.example.chatapp.network.SocketClient
import com.google.android.material.button.MaterialButton
import com.google.android.material.textfield.TextInputLayout
import java.io.IOException
import java.util.concurrent.TimeUnit

class AuthentificationActivity : AppCompatActivity() {

    lateinit var tvRegister: TextView
    lateinit var layoutTextInputLogin: TextInputLayout
    lateinit var layoutTextInputPassword: TextInputLayout
    lateinit var btnConnect: MaterialButton
    lateinit var errorMessage: TextView


    @SuppressLint("MissingInflatedId")
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_authentification)
        tvRegister = findViewById(R.id.tvRegister)
        layoutTextInputLogin = findViewById(R.id.layoutTextInputLogin)
        layoutTextInputPassword = findViewById(R.id.layoutTextInputPassword)
        btnConnect = findViewById(R.id.btnConnect)
        errorMessage = findViewById(R.id.errorMessage)

        tvRegister.setOnClickListener {
            Intent(this, RegisterActivity::class.java).also {
                startActivity(it)
            }
        }

        btnConnect.setOnClickListener {
            layoutTextInputLogin.isErrorEnabled = false
            layoutTextInputPassword.isErrorEnabled = false

            val login = layoutTextInputLogin.editText?.text.toString()
            val password = layoutTextInputPassword.editText?.text.toString()

            if (login.isEmpty() || password.isEmpty()) {
                if (login.isEmpty()) {
                    layoutTextInputLogin.error = "Le login est requis !"
                    layoutTextInputLogin.isErrorEnabled = true
                }
                if (password.isEmpty()) {
                    layoutTextInputPassword.error = "Le mot de passe est requis !"
                    layoutTextInputPassword.isErrorEnabled = true
                }
            } else {
                signIn(login, password, errorMessage)
            }
        }

    }

    @SuppressLint("SetTextI18n")
    fun signIn(login: String, password: String, error: TextView) {
        Log.d("signIn","Connexion utilisateur...")
        error.text = ""

        val connection = SocketClient()

        Thread {
            try {
                var response = connection.Login(login, password)
                if (response.startsWith("error")) {
                    runOnUiThread {
                        error.text = "Identifiants invalides"
                    }
                    connection.Disconnect()
                    return@Thread
                }
                connection.Disconnect()
                Intent(this, HomeActivity::class.java).also {
                    startActivity(it)
                }
                finish()
            } catch (e: IOException) {
                e.printStackTrace()
                runOnUiThread {
                    error.text = "Erreur inconnue"
                }
                connection.Disconnect()
            }
        }.start()


    }
}