/*
 * Decompiled with CFR 0.152.
 */
package org.example;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.example.account.Account;
import org.example.db.Database;
import org.example.server.Globals;
import org.example.server.ServerThread;

public class Main {
    private static void init_db(Connection connection, Globals globals) {
        PreparedStatement statement;
        try {
            statement = connection.prepareStatement("        create table if not exists ACCOUNT\n          (\n              id       int auto_increment\n                  primary key,\n              login    varchar(255) not null,\n              password varchar(255) not null,\n              constraint login\n                  unique (login)\n          );\n");
            try {
                statement.execute();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        try {
            statement = connection.prepareStatement("        create table if not exists GENERAL\n          (\n              id      int auto_increment\n                  primary key,\n              user_id int           not null,\n              message varchar(1024) not null,\n              constraint GENERAL_ACCOUNT_id_fk\n                  foreign key (user_id) references ACCOUNT (id)\n          );\n");
            try {
                statement.execute();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        try {
            statement = connection.prepareStatement("        create table if not exists PRIVATEMSG\n          (\n              id       int auto_increment,\n              user1_id int           not null,\n              user2_id int           not null,\n              message  varchar(1024) not null,\n              constraint PRIVATEMSG_pk\n                  primary key (id)\n          );\n");
            try {
                statement.execute();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        try {
            statement = connection.prepareStatement("        create table if not exists PRIVATEMSG\n          (\n              id       int auto_increment,\n              user1_id int           not null,\n              user2_id int           not null,\n              message  varchar(1024) not null,\n              constraint PRIVATEMSG_pk\n                  primary key (id)\n          );\n");
            try {
                statement.execute();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        Account.createAccount(connection, globals, "admin", "pass");
    }

    public static void main(String[] args) throws SQLException, IOException {
        System.out.print("Server initialization...");
        Globals lists = new Globals();
        Connection connection = Database.newConnection();
        Main.init_db(connection, lists);
        connection.close();
        System.out.println("Done");
        ServerSocket server = null;
        try {
            server = new ServerSocket(42233);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        Socket new_client = null;
        while (true) {
            try {
                new_client = server.accept();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println("Client accepted");
            if (new_client == null) continue;
            ServerThread client = new ServerThread(new_client, lists);
            lists.listClient.add(client);
            Thread t = new Thread(client);
            t.start();
            client.setThread(t);
            System.out.println("Thread launched");
            new_client = null;
        }
    }
}

