/*
 * Decompiled with CFR 0.152.
 */
package org.example.server;

import java.net.Socket;
import java.sql.Connection;
import org.example.account.User;
import org.example.server.Globals;
import org.example.server.IOCommandes;
import org.example.server.Parser;

public class ServerThread
implements Runnable {
    private Socket client;
    public User user;
    private Thread thread;
    public IOCommandes stream;
    private Globals globals;
    private Parser parser;
    private Connection connection;

    public ServerThread(Socket client, Globals globals) {
        this.client = client;
        this.globals = globals;
        this.parser = new Parser();
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    @Override
    public void run() {
        this.stream = new IOCommandes(this.client);
        while (true) {
            String response;
            String line = this.stream.lireReseau();
            System.out.println("client> " + line);
            if (line == null) break;
            if (line.isEmpty()) {
                this.stream.ecrireReseau("Error: Unknown command");
            }
            if ((response = this.parser.getParser(this.connection, this, this.globals, line)).equals("OK SET")) {
                this.stream.ecrireReseau("ALL OK");
                continue;
            }
            this.stream.ecrireReseau(response);
        }
        this.globals.listClient.remove(this);
        System.out.println("Client disconnected");
    }
}

